/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed*0.3
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define t iGlobalTime*0.5
#define R (100.+cos(t+1.)*50.)

float isPrime(float n)
{
	float d = floor(sqrt(n))+1.0;

	for(int i = 0; i < 1000; i++)
    {
		if (d < 2.0) { break; }
        if (mod(n,d--) == 0.0) { return 0.0; }
	}
 
	return 1.0;
}

void main()
{
	vec2 z = floor(R*(2.*gl_FragCoord.xy-iResolution.xy)/iResolution.xx+0.5);
	gl_FragColor = vec4(floor(isPrime(dot(z,z))))*cos(length(z)*0.01);
}